/*
 * Decompiled with CFR 0.152.
 */
import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileNameExtensionFilter;
import processing.core.PApplet;
import processing.serial.Serial;

public class Compression_tester
extends PApplet {
    final byte STATE_START = 1;
    final byte STATE_CONNECTED = (byte)2;
    final byte STATE_READY = (byte)3;
    final byte STATE_MEASURE = (byte)4;
    final byte STATE_END = (byte)8;
    final byte EXPECT_NO = 0;
    final byte EXPECT_VER = 1;
    final byte EXPECT_PRESSURE = (byte)2;
    JFileChooser fc;
    FileNameExtensionFilter filter;
    volatile int rxExpect = 0;
    Serial com;
    PrintWriter log;
    int comIdx = -1;
    String portInput = "0";
    File selection = null;
    String txtStatus = "Choose serial port..";
    String txtDevice = null;
    String[] ports = null;
    String txtPressure = null;
    volatile long lastPacket;
    volatile String scratch = "";
    volatile int attempts;
    PressureArray compressionCurve = new PressureArray();
    Compression curCompression = new Compression();
    Compression compCompression = new Compression();
    CompressionArray compressionArray = new CompressionArray();
    PressurePoint drawPnt;
    PressurePoint drawPntPrev;
    int minP;
    int maxP;
    int minADC;
    int maxADC;
    float interval;
    float curTime;
    boolean[] buttonsPushed = new boolean[35];
    byte state = 1;
    boolean refreshAble = true;

    public void setup() {
        int i = 0;
        while (i < this.buttonsPushed.length) {
            this.buttonsPushed[i] = false;
            ++i;
        }
        this.surface.setTitle("Nopistons.ru rotary compression tester");
        this.background(0);
        this.textSize(14.0f);
        this.log = this.createWriter("debug.log");
        this.frameRate(25.0f);
        this.thread("wd_thread");
    }

    public void draw() {
        int i;
        if (this.millis() % 1000 < 500 && this.refreshAble) {
            this.refreshAble = false;
            this.refreshPorts();
        } else if (this.millis() % 1000 > 500) {
            this.refreshAble = true;
        }
        this.background(0);
        this.stroke(180);
        this.line(150.0f, 0.0f, 150.0f, this.height);
        if (this.ports != null) {
            i = 0;
            while (i < this.ports.length && i < 10) {
                if (this.ports[i] != null) {
                    String txt;
                    String string = txt = this.ports[i].contains("/dev/") ? this.ports[i].substring(5) : this.ports[i];
                    if (txt.length() > 14) {
                        txt = txt.substring(0, 14);
                    }
                    this.drawButton(txt, 10, 70 + i * 40, 139, 100 + i * 40, i);
                }
                ++i;
            }
        }
        if (this.state == 2 || this.state == 3) {
            this.drawButton("Disconnect", 10, this.height - 40, 139, this.height - 10, 20);
        }
        if (this.state == 8 || this.state == 1) {
            this.drawButton("Load file", 10, 10, 139, 40, 21);
        }
        if (this.state == 8) {
            this.drawButton("Save as", 550, 440, 630, 470, 22);
        }
        this.colorText();
        this.text("Com ports: ", 10.0f, 60.0f);
        this.text(this.txtStatus, 170.0f, 20.0f);
        if (this.txtDevice != null) {
            this.text(this.txtDevice, 170.0f, 40.0f);
        }
        if ((this.state == 3 || this.state == 4) && this.txtPressure != null) {
            this.text(this.txtPressure, 170.0f, 440.0f);
        }
        this.fill(0);
        this.stroke(240);
        this.rect(170.0f, this.pressToY(10.0f), 430.0f, this.pressToY(-1.0f) - 60.0f);
        this.fill(240);
        i = 0;
        while (i < 10) {
            this.line(171.0f, this.pressToY(i), 600.0f, this.pressToY(i));
            this.text(i, 610.0f, this.pressToY(i) + 4.0f);
            ++i;
        }
        if (this.state == 4 || this.state == 8) {
            this.stroke(150.0f, 150.0f, 255.0f);
            if (this.compressionCurve.getCount() > 0) {
                this.drawPntPrev = this.compressionCurve.getItem(0);
            }
            int p = 1;
            while (p < this.compressionCurve.getCount()) {
                this.drawPnt = this.compressionCurve.getItem(p);
                this.line(this.timeToX(this.drawPntPrev.getTime()), this.pressToY(this.drawPntPrev.getValue()), this.timeToX(this.drawPnt.getTime()), this.pressToY(this.drawPnt.getValue()));
                this.drawPntPrev = this.drawPnt;
                ++p;
            }
            if (this.state == 8) {
                this.stroke(0.0f, 0.0f, 0.0f, 0.0f);
                this.fill(200.0f, 150.0f, 150.0f, 100.0f);
                float startX = this.timeToX(this.curCompression.getStartTime());
                this.rect(startX, this.pressToY(10.0f) + 1.0f, this.timeToX(this.curCompression.getEndTime()) - startX, this.pressToY(-1.0f) - 62.0f);
                this.colorText();
                this.text(String.format("Compression: %.2f, %.2f, %.2f [kg/cm2] @ %.0f RPM", Float.valueOf(this.curCompression.chamber1), Float.valueOf(this.curCompression.chamber2), Float.valueOf(this.curCompression.chamber3), Float.valueOf(this.curCompression.rpm)), 170.0f, 400.0f);
                this.text(String.format("Compensated: %.2f, %.2f, %.2f [kg/cm2] @ %.0f RPM", Float.valueOf(this.compCompression.chamber1), Float.valueOf(this.compCompression.chamber2), Float.valueOf(this.compCompression.chamber3), Float.valueOf(this.compCompression.rpm)), 170.0f, 420.0f);
            }
        }
    }

    public void buttonAction(int act) {
        switch (act) {
            case -1: {
                break;
            }
            case 20: {
                this.state = 1;
                this.comKill();
                this.txtDevice = null;
                this.txtStatus = "Choose serial port";
                break;
            }
            case 21: {
                this.fc = new JFileChooser();
                this.filter = new FileNameExtensionFilter("Log file (*.msl)", "msl");
                this.fc.setFileFilter(this.filter);
                int ret = this.fc.showOpenDialog(null);
                if (ret != 0) break;
                this.selection = this.fc.getSelectedFile();
                String filePath = this.selection.getAbsolutePath();
                int idx = filePath.lastIndexOf(47) + 1;
                if (idx == 0) {
                    idx = filePath.lastIndexOf(92) + 1;
                }
                if (idx == 0) {
                    idx = 0;
                }
                String fileName = filePath.substring(idx);
                FileInputStream fin = null;
                try {
                    fin = new FileInputStream(filePath);
                    BufferedReader reader = new BufferedReader(new InputStreamReader(fin));
                    String line = null;
                    int a = 0;
                    this.curCompression.reset();
                    this.compressionArray.reset();
                    this.compressionCurve.clear();
                    while ((line = reader.readLine()) != null) {
                        if (a > 2) {
                            line = line.replace(",", ".");
                            String[] number = line.split("\\t+");
                            float time = Float.parseFloat(number[0]);
                            float val = Float.parseFloat(number[1]);
                            this.compressionCurve.add(new PressurePoint(time, val));
                        }
                        ++a;
                    }
                    reader.close();
                    fin.close();
                    this.updateStatus("File: " + fileName);
                    this.compressionArray = this.compressionCurve.getCompressionArray(3.0f, 2.8f);
                    this.curCompression = this.compressionArray.getBestCompression();
                    this.compCompression = this.curCompression.compensateTo250rpm();
                    this.state = (byte)8;
                    this.rxExpect = 0;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                break;
            }
            case 22: {
                int idx;
                this.fc = new JFileChooser();
                this.filter = new FileNameExtensionFilter("Log file (*.msl)", "msl");
                this.fc.setFileFilter(this.filter);
                int ret = this.fc.showSaveDialog(null);
                if (ret != 0) break;
                this.selection = this.fc.getSelectedFile();
                String filePath = this.selection.getAbsolutePath();
                if (filePath.length() - filePath.indexOf(".msl") != 4) {
                    filePath = String.valueOf(filePath) + ".msl";
                }
                if ((idx = filePath.lastIndexOf(47) + 1) == 0) {
                    idx = filePath.lastIndexOf(92) + 1;
                }
                if (idx == 0) {
                    idx = 0;
                }
                String fileName = filePath.substring(idx);
                FileOutputStream fout = null;
                try {
                    fout = new FileOutputStream(filePath);
                    BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(fout));
                    String h1 = "Nopistons.ru compresion tester\n";
                    String h2 = "Time\tPressure\n";
                    String h3 = "s\tkg_cm2\n";
                    writer.write(h1, 0, h1.length());
                    writer.write(h2, 0, h2.length());
                    writer.write(h3, 0, h3.length());
                    int i = 0;
                    while (i < this.compressionCurve.getCount()) {
                        String time = String.format("%.5f", Float.valueOf(this.compressionCurve.getItem(i).getTime()));
                        String pressure = String.format("%.3f", Float.valueOf(this.compressionCurve.getItem(i).getValue()));
                        writer.write(time, 0, time.length());
                        writer.write("\t");
                        writer.write(pressure, 0, pressure.length());
                        writer.newLine();
                        ++i;
                    }
                    writer.close();
                    fout.close();
                    this.updateStatus("Saved to " + fileName);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                break;
            }
            default: {
                if (act > 20) break;
                this.txtDevice = null;
                try {
                    this.state = (byte)2;
                    this.comKill();
                    this.attempts = 0;
                    this.com = new Serial((PApplet)this, this.ports[act], 1000000);
                    this.com.bufferUntil(10);
                    this.updateStatus("Connecting to " + this.ports[act]);
                    this.txtDevice = "no supported device found";
                    this.com.clear();
                    this.delay(500);
                    this.com.write("p");
                    this.delay(350);
                    this.com.clear();
                    this.delay(100);
                    this.com.read();
                    this.rxExpect = 1;
                    this.lastPacket = this.millis();
                    this.com.write("pv");
                    break;
                }
                catch (RuntimeException runtimeException) {
                    this.updateStatus("Could not open port " + this.ports[act]);
                    this.state = 1;
                    this.comKill();
                }
            }
        }
    }

    public void serialEvent(Serial p) {
        this.lastPacket = this.millis();
        p.available();
        String input = p.readString();
        if (this.rxExpect == 0) {
            this.scratch = "";
        } else if (this.rxExpect == 1) {
            input = String.valueOf(this.scratch) + input;
            if (input.indexOf(10) > 0) {
                this.log.println("Version: " + input);
                this.log.flush();
                if (this.checkSig(input) > 0) {
                    this.updateStatus("Found supported device.");
                    this.state = (byte)3;
                    this.delay(100);
                    this.com.clear();
                    this.lastPacket = this.millis();
                    this.scratch = "";
                    this.rxExpect = 2;
                    this.com.write(115);
                    this.updateStatus("Ready to crank");
                } else {
                    this.comKill();
                    this.updateStatus("Device not supported: " + input);
                }
            } else {
                this.scratch = input;
            }
        } else if (this.rxExpect == 2) {
            this.scratch = this.parseIn(String.valueOf(this.scratch) + input);
        }
    }

    public void wd_thread() {
        while (true) {
            long m = this.millis();
            if ((m -= this.lastPacket) <= 1000L) continue;
            if (this.rxExpect == 1) {
                if (this.attempts < 6) {
                    this.com.write(118);
                    Compression_tester.println((char)'v');
                    this.lastPacket = this.millis();
                    ++this.attempts;
                    continue;
                }
                this.comKill();
                this.updateStatus("Connecting timeout..");
                continue;
            }
            if (this.rxExpect <= 0) continue;
            this.comKill();
            this.updateStatus("Recieve timeout..");
            if (this.state != 8) continue;
            this.updateStatus("Test finished");
            this.compressionArray = this.compressionCurve.getCompressionArray(3.0f, 2.8f);
            this.curCompression = this.compressionArray.getBestCompression();
            this.compCompression = this.curCompression.compensateTo250rpm();
        }
    }

    public void comKill() {
        this.rxExpect = 0;
        if (this.state != 8) {
            this.state = 1;
        }
        if (this.com != null) {
            if (this.com.active()) {
                this.com.write(112);
            }
            this.delay(200);
            this.com.clear();
            this.com.stop();
        }
        this.txtDevice = null;
    }

    public void updateStatus(String status) {
        this.txtStatus = status;
        if (status == null) {
            status = "Null";
        }
        Compression_tester.println((String)status);
        this.log.println(status);
        this.log.flush();
    }

    public void actionPerformed(ActionEvent e) {
    }

    public void drawButton(String txt, int x1, int y1, int x2, int y2, int act) {
        if (act < 0 || act > 35) {
            return;
        }
        if (this.mouseX >= x1 && this.mouseX <= x2 && this.mouseY >= y1 && this.mouseY <= y2 && (this.state == 1 || this.state == 8 || act > 18)) {
            if (this.mousePressed) {
                this.colorPressed();
                if (!this.buttonsPushed[act]) {
                    this.buttonAction(act);
                }
                this.buttonsPushed[act] = true;
            } else {
                this.colorHover();
                this.buttonsPushed[act] = false;
            }
        } else {
            this.colorDefault();
            if (!this.mousePressed) {
                this.buttonsPushed[act] = false;
            }
        }
        this.rect(x1, y1, x2 - x1, y2 - y1);
        this.colorText();
        this.text(txt, x1 + 10, y1 + (y2 - y1) / 2 + 6);
    }

    public void colorPressed() {
        this.stroke(180);
        this.fill(110.0f, 40.0f, 40.0f);
    }

    public void colorText() {
        this.fill(240);
        this.noStroke();
        this.textSize(14.0f);
    }

    public void colorDefault() {
        this.stroke(180);
        this.fill(50.0f, 50.0f, 80.0f);
    }

    public void colorHover() {
        this.stroke(180);
        this.fill(60.0f, 60.0f, 90.0f);
    }

    public float pressToY(float press) {
        if (press > 10.0f) {
            press = 10.0f;
        }
        if (press < -1.0f) {
            press = -1.0f;
        }
        float ans = 360.0f - (press + 1.0f) * 27.0f;
        return ans;
    }

    public float timeToX(float time) {
        if (time < 0.0f) {
            time = 0.0f;
        }
        if (time > 7.0f) {
            time = 7.0f;
        }
        return Compression_tester.map((float)time, (float)0.0f, (float)7.0f, (float)170.0f, (float)600.0f);
    }

    public String parseIn(String in) {
        while (in.indexOf(10) >= 0) {
            int i = in.indexOf(10);
            String packet = in.substring(0, i);
            Float v = Float.valueOf(this.convertPress(Integer.parseInt(packet, 16)));
            this.txtPressure = String.format("Pressure: %.2f kg/cm2", v);
            in = in.substring(i + 1);
            if (this.state == 3 && v.floatValue() >= 1.5f) {
                this.curCompression.reset();
                this.compressionArray.reset();
                this.compressionCurve.clear();
                this.curTime = 0.0f;
                this.state = (byte)4;
                this.updateStatus("Cranking...");
            }
            if (this.state != 4) continue;
            this.curTime += this.interval;
            this.compressionCurve.add(new PressurePoint(this.curTime, v.floatValue()));
            if (!(this.curTime > 6.5f)) continue;
            this.state = (byte)8;
            this.com.write(112);
        }
        return in;
    }

    public float convertPress(int val) {
        return Compression_tester.map((float)val, (float)this.minADC, (float)this.maxADC, (float)this.minP, (float)this.maxP);
    }

    public byte checkSig(String sig) {
        int a = sig.indexOf("ID:nopistons_ru_compression_tester,Version:1");
        if (a < 0) {
            return 0;
        }
        try {
            int b = sig.indexOf(44);
            this.txtDevice = sig.substring(a + 3, b);
            sig = sig.substring(b + 1);
            b = sig.indexOf(44);
            sig = sig.substring(b + 1);
            a = sig.indexOf(58);
            b = sig.indexOf(44);
            this.minP = Integer.parseInt(sig.substring(a + 1, b));
            a = sig.indexOf(58, b + 1);
            b = sig.indexOf(44, a);
            this.maxP = Integer.parseInt(sig.substring(a + 1, b));
            a = sig.indexOf(58, b + 1);
            b = sig.indexOf(44, a);
            this.minADC = Integer.parseInt(sig.substring(a + 1, b));
            a = sig.indexOf(58, b + 1);
            b = sig.indexOf(44, a);
            this.maxADC = Integer.parseInt(sig.substring(a + 1, b));
            a = sig.indexOf(58, b + 1);
            b = sig.indexOf(44, a);
            this.interval = (float)Integer.parseInt(sig.substring(a + 1, b)) / 1000000.0f;
            this.log.println("Parameters: " + sig);
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            return 0;
        }
        return 1;
    }

    public void refreshPorts() {
        String[] tmpList = Serial.list();
        String[] exclude = this.loadStrings("exclude-serial.txt");
        if (exclude == null) {
            this.ports = tmpList;
            Compression_tester.println((String)"null");
            return;
        }
        if (tmpList == null) {
            this.ports = null;
            return;
        }
        this.ports = new String[tmpList.length];
        int i = 0;
        int a = 0;
        while (a < tmpList.length) {
            boolean exc = false;
            int b = 0;
            while (b < exclude.length) {
                if (Compression_tester.trim((String)tmpList[a]).equals(Compression_tester.trim((String)exclude[b]))) {
                    exc = true;
                }
                ++b;
            }
            if (!exc) {
                this.ports[i] = tmpList[a];
                ++i;
            }
            ++a;
        }
    }

    public void settings() {
        this.size(640, 480);
    }

    public static void main(String[] passedArgs) {
        String[] appletArgs = new String[]{"Compression_tester"};
        if (passedArgs != null) {
            PApplet.main((String[])Compression_tester.concat((String[])appletArgs, (String[])passedArgs));
        } else {
            PApplet.main((String[])appletArgs);
        }
    }

    public class Compression {
        public float chamber1;
        public float chamber2;
        public float chamber3;
        public float rpm;
        private float startTime;
        private float endTime;

        public Compression() {
            this.reset();
        }

        public Compression(float chamber1, float chamber2, float chamber3, float rpm) {
            this.chamber1 = chamber1;
            this.chamber2 = chamber2;
            this.chamber3 = chamber3;
            this.rpm = rpm;
            this.startTime = 0.0f;
            this.endTime = 0.0f;
        }

        public Compression(float chamber1, float chamber2, float chamber3, float rpm, float s_time, float e_time) {
            this.chamber1 = chamber1;
            this.chamber2 = chamber2;
            this.chamber3 = chamber3;
            this.rpm = rpm;
            this.startTime = s_time;
            this.endTime = e_time;
        }

        public void reset() {
            this.chamber1 = 0.0f;
            this.chamber2 = 0.0f;
            this.chamber3 = 0.0f;
            this.rpm = 0.0f;
            this.startTime = 0.0f;
            this.endTime = 0.0f;
        }

        public Compression compensateTo250rpm() {
            Compression result;
            if (this.rpm > 150.0f && this.rpm < 350.0f) {
                float multiplier = -0.0024f * this.rpm + 1.6f;
                result = new Compression(multiplier * this.chamber1, multiplier * this.chamber2, multiplier * this.chamber3, 250.0f);
            } else {
                result = new Compression();
            }
            return result;
        }

        public float getStartTime() {
            return this.startTime;
        }

        public void setStartTime(float startTime) {
            this.startTime = startTime;
        }

        public float getEndTime() {
            return this.endTime;
        }

        public void setEndTime(float endTime) {
            this.endTime = endTime;
        }
    }

    public class CompressionArray {
        private List<Compression> list = new ArrayList<Compression>();
        private Compression bestCompression;
        private boolean bestWasCalculated;

        public CompressionArray() {
            this.bestCompression = new Compression();
            this.bestWasCalculated = false;
        }

        public int getCount() {
            return this.list.size();
        }

        public Compression getItem(int position) {
            return this.list.get(position);
        }

        public void addItem(Compression item) {
            this.list.add(item);
            this.bestWasCalculated = false;
        }

        public Compression getBestCompression() {
            if (!this.bestWasCalculated) {
                this.bestCompression.reset();
                if (this.list.size() > 0) {
                    float maxRPM = 0.0f;
                    int a = 0;
                    while (a < this.list.size()) {
                        float tmpRPM = this.list.get((int)a).rpm;
                        if (tmpRPM >= maxRPM) {
                            maxRPM = tmpRPM;
                            this.bestCompression = this.list.get(a);
                        }
                        ++a;
                    }
                }
                this.bestWasCalculated = true;
            }
            return this.bestCompression;
        }

        public Compression getClosestToTime(float time) {
            Compression result = new Compression();
            if (this.list.size() > 0) {
                float minDelta = 500.0f;
                int a = 0;
                while (a < this.list.size()) {
                    Compression item = this.list.get(a);
                    float middleTime = (item.getStartTime() + item.getEndTime()) / 2.0f;
                    if (Math.abs(time - middleTime) < minDelta) {
                        minDelta = Math.abs(time - middleTime);
                        result = item;
                    }
                    ++a;
                }
            }
            return result;
        }

        public void reset() {
            this.bestWasCalculated = false;
            this.list.clear();
        }
    }

    public class PressureArray {
        private List<PressurePoint> list;
        private CompressionArray compressionArray;
        private boolean compressionWasCalculated = false;

        public PressureArray(List<PressurePoint> list) {
            this.list = list;
            this.compressionArray = new CompressionArray();
        }

        public PressureArray() {
            this.list = new ArrayList<PressurePoint>();
            this.compressionArray = new CompressionArray();
        }

        public void resetCompressionArray() {
            this.compressionWasCalculated = false;
        }

        public int getCount() {
            return this.list.size();
        }

        public PressurePoint getItem(int position) {
            return this.list.get(position);
        }

        public void clear() {
            this.list.clear();
            this.compressionWasCalculated = false;
            this.compressionArray.reset();
        }

        public void add(PressurePoint point) {
            this.list.add(point);
            this.compressionWasCalculated = false;
        }

        public CompressionArray getCompressionArray(float toleranceA, float toleranceB) {
            if (!this.compressionWasCalculated) {
                this.compressionArray.reset();
                ArrayList<PressurePoint> peakPoints = new ArrayList<PressurePoint>();
                float prevValue = toleranceB;
                boolean rising = true;
                int a = 0;
                while (a < this.list.size()) {
                    float curValue = this.list.get(a).getValue();
                    if (curValue > toleranceA && rising) {
                        if (curValue > prevValue) {
                            prevValue = curValue;
                        } else {
                            peakPoints.add(new PressurePoint(this.list.get(a - 1).getTime(), prevValue));
                            rising = false;
                            prevValue = toleranceB;
                        }
                    }
                    if (curValue < toleranceB) {
                        rising = true;
                    }
                    ++a;
                }
                if (peakPoints.size() > 2) {
                    int size = peakPoints.size();
                    int a2 = 0;
                    while (a2 + 2 < size) {
                        float timeStart = ((PressurePoint)peakPoints.get(a2)).getTime();
                        float timeEnd = ((PressurePoint)peakPoints.get(a2 + 2)).getTime();
                        float rpm = 120.0f / (timeEnd - timeStart);
                        if (rpm > 150.0f) {
                            float chamber1 = ((PressurePoint)peakPoints.get(a2)).getValue();
                            float chamber2 = ((PressurePoint)peakPoints.get(a2 + 1)).getValue();
                            float chamber3 = ((PressurePoint)peakPoints.get(a2 + 2)).getValue();
                            this.compressionArray.addItem(new Compression(chamber1, chamber2, chamber3, rpm, timeStart, timeEnd));
                        }
                        ++a2;
                    }
                }
                this.compressionWasCalculated = true;
            }
            return this.compressionArray;
        }

        public void trimBegin(float tolerance, int deadPoints) {
            if (this.list.size() > deadPoints) {
                boolean flag = true;
                while (flag) {
                    if (this.list.get(deadPoints).getValue() < tolerance) {
                        this.list.remove(0);
                        if (this.list.size() > deadPoints) continue;
                        flag = false;
                        continue;
                    }
                    flag = false;
                }
                if (this.list.get(0).getTime() > 0.0f) {
                    float offset = this.list.get(0).getTime();
                    int a = 0;
                    while (a < this.list.size()) {
                        PressurePoint pnt = this.list.get(a);
                        pnt.setTime(pnt.getTime() - offset);
                        this.list.set(a, pnt);
                        ++a;
                    }
                }
            }
        }
    }

    public class PressurePoint {
        private float time;
        private float value;

        public PressurePoint(float time, float value) {
            this.time = time;
            this.value = value;
        }

        public float getTime() {
            return this.time;
        }

        public void setTime(float time) {
            this.time = time;
        }

        public float getValue() {
            return this.value;
        }

        public void setValue(float value) {
            this.value = value;
        }
    }
}

