/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.PrintWriter;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileNameExtensionFilter;
import processing.core.PApplet;
import processing.serial.Serial;

public class DM_firmware_loader_v01
extends PApplet {
    final byte STATE_START = 1;
    final byte STATE_CONNECTED = (byte)2;
    final byte STATE_LOAD_RDY = (byte)3;
    final byte STATE_LOADING = (byte)4;
    final byte STATE_END = (byte)5;
    Serial com;
    PrintWriter log;
    int comIdx = -1;
    int MaxTextWidth = 80;
    String portInput = "0";
    File selection = null;
    String txtStatus = "Choose serial port..";
    String txtDevice = null;
    String[] ports = null;
    byte[] sigDevice = null;
    boolean[] buttonsPushed = new boolean[21];
    byte state = 1;
    float progress = 0.0f;
    byte[][] supDevices = new byte[][]{{68, 77, 32, 66, 79, 79, 84, 76, 79, 65, 68, 69, 82, 32, 95, 48, 48, 69, 70}, {71, 80, 73, 79, 32, 84, 101, 109, 112, 108, 97, 116, 101, 32, 68, 77, 48, 48, 48}};
    byte[][] supMask = new byte[][]{{49, 49, 49, 49, 49, 49, 49, 49, 49, 49, 49, 49, 49, 49, 49, 49, 49, 49, 49}, {49, 49, 49, 49, 49, 49, 49, 49, 49, 49, 49, 49, 49, 49, 49, 49, 49, 48, 48}};
    boolean[] supReboot;
    byte[] jumperlessCmd;
    boolean refreshAble;
    final byte ERROR_OK = 17;
    final byte ERROR_CRC = 34;
    final byte ERROR_TIMEOUT = 51;
    final byte ERROR_PAGESIZE = 68;
    final byte BOOT_CRC_OK = -69;
    final byte BOOT_CRC_FAIL = -86;

    public DM_firmware_loader_v01() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        this.supReboot = blArray;
        byte[] byArray = new byte[16];
        byArray[0] = 74;
        byArray[1] = 85;
        byArray[2] = 77;
        byArray[3] = 80;
        byArray[4] = 69;
        byArray[5] = 82;
        byArray[6] = 76;
        byArray[7] = 69;
        byArray[8] = 83;
        byArray[9] = 83;
        byArray[10] = 32;
        byArray[11] = 66;
        byArray[12] = 79;
        byArray[13] = 79;
        byArray[14] = 84;
        this.jumperlessCmd = byArray;
        this.refreshAble = true;
        this.ERROR_OK = (byte)17;
        this.ERROR_CRC = (byte)34;
        this.ERROR_TIMEOUT = (byte)51;
        this.ERROR_PAGESIZE = (byte)68;
        this.BOOT_CRC_OK = (byte)-69;
        this.BOOT_CRC_FAIL = (byte)-86;
    }

    public void setup() {
        int i = 0;
        while (i < this.buttonsPushed.length) {
            this.buttonsPushed[i] = false;
            ++i;
        }
        this.background(0);
        this.textSize(14.0f);
        this.log = this.createWriter("update.log");
        this.frameRate(25.0f);
    }

    public void draw() {
        if (this.millis() % 1000 < 500 && this.refreshAble) {
            this.refreshAble = false;
            this.refreshPorts();
        } else if (this.millis() % 1000 > 500) {
            this.refreshAble = true;
        }
        this.background(0);
        this.stroke(180);
        this.line(150.0f, 0.0f, 150.0f, this.height);
        if (this.ports != null) {
            int i = 0;
            while (i < this.ports.length && i < 10) {
                if (this.ports[i] != null) {
                    this.drawButton(this.ports[i], 10, 30 + i * 40, 139, 60 + i * 40, i);
                }
                ++i;
            }
        }
        if (this.state == 2 || this.state == 3 || this.state == 5) {
            this.drawButton("Disconnect", 10, this.height - 40, 139, this.height - 10, 20);
        }
        if (this.state == 3) {
            this.drawButton("Update", 162, this.height - 40, 289, this.height - 10, 19);
        }
        this.colorText();
        this.text("Com ports: ", 10.0f, 20.0f);
        this.text(this.txtStatus, 170.0f, 20.0f);
        if (this.txtDevice != null) {
            this.text(this.txtDevice, 170.0f, 40.0f);
        }
        if (this.state == 4 || this.state == 5) {
            int Ysize = 400;
            int Yfill = PApplet.parseInt((float)(this.progress * (float)Ysize / 100.0f));
            this.fill(0);
            this.stroke(240);
            this.rect(170.0f, 60.0f, Ysize, 20.0f);
            this.fill(60.0f, 60.0f, 90.0f);
            this.rect(170.0f, 60.0f, Yfill, 20.0f);
        }
    }

    public void buttonAction(int act) {
        switch (act) {
            case -1: {
                break;
            }
            case 20: {
                this.state = 1;
                if (this.com != null) {
                    this.com.stop();
                }
                this.txtDevice = null;
                this.txtStatus = "Choose serial port";
                break;
            }
            case 19: {
                this.txtStatus = "Choose update file";
                JFileChooser fc = new JFileChooser();
                FileNameExtensionFilter filter = new FileNameExtensionFilter("DM update file", "dma");
                fc.setFileFilter(filter);
                int ret = fc.showOpenDialog(null);
                if (ret != 0) break;
                this.state = (byte)4;
                this.selection = fc.getSelectedFile();
                this.progress = 0.0f;
                this.thread("loader");
                break;
            }
            default: {
                this.txtDevice = null;
                try {
                    this.state = (byte)2;
                    if (this.com != null) {
                        this.com.stop();
                    }
                    this.com = new Serial((PApplet)this, this.ports[act], 115200);
                    this.updateStatus("Connecting to " + this.ports[act]);
                    this.thread("stage1");
                    break;
                }
                catch (RuntimeException runtimeException) {
                    this.updateStatus("Could not open port " + this.ports[act]);
                    this.state = 1;
                }
            }
        }
    }

    public void stage1() {
        this.txtDevice = "no supported device found";
        byte ans = 0;
        this.com.clear();
        this.com.write(81);
        this.delay(250);
        this.sigDevice = this.com.readBytesUntil(0);
        if (this.sigDevice != null) {
            this.log.println("Signature: " + this.byteA2hex(this.sigDevice));
        }
        this.log.flush();
        if (this.sigDevice != null && this.sigDevice.length == 20) {
            this.com.write(83);
            this.delay(250);
            this.txtDevice = this.com.readStringUntil(0);
            this.txtDevice = this.txtDevice == null ? "null" : this.txtDevice.trim();
            ans = this.checkSig(this.sigDevice);
            if (ans == 2) {
                this.txtStatus = "Found supported device:";
                this.state = (byte)3;
            } else if (ans == 1) {
                this.txtStatus = "Found empty device (no FW loaded):";
                this.state = (byte)3;
            } else {
                this.txtStatus = "Device not supported:";
            }
        }
    }

    public void loader() {
        this.log.println("Update file: " + this.selection.getAbsolutePath());
        this.log.flush();
        DM_firmware_loader_v01.println((String)this.selection.getAbsolutePath());
        byte[] b = this.loadBytes(this.selection.getAbsolutePath());
        int len = b.length;
        byte[] o = new byte[len / 2];
        this.log.println("File size: " + len);
        this.log.flush();
        int x = 0;
        while (x < len - 1 && b[x] != 0) {
            byte z = (byte)(this.ascii2hex(b[x]) * 16);
            o[x / 2] = z = (byte)(z + this.ascii2hex(b[x + 1]));
            x += 2;
        }
        len = o.length;
        this.updateStatus("Update size: " + len + " bytes");
        int ans = 0;
        int attempts = 1;
        while (attempts < 5 && ans != 1) {
            this.txtDevice = "no device found";
            ans = 0;
            this.com.clear();
            this.com.write(81);
            this.delay(250);
            this.sigDevice = this.com.readBytesUntil(0);
            if (this.sigDevice != null) {
                this.log.println("Signature: " + this.byteA2hex(this.sigDevice));
            }
            this.log.flush();
            if (this.sigDevice != null && this.sigDevice.length == 20) {
                this.com.write(83);
                this.delay(250);
                this.txtDevice = this.com.readStringUntil(0);
                this.txtDevice = this.txtDevice == null ? "null" : this.txtDevice.trim();
                ans = this.checkSig(this.sigDevice);
            }
            if (ans == 2) {
                this.updateStatus("Sending jumperless boot command... " + attempts);
                this.com.write(this.jumperlessCmd);
                this.delay(200);
            } else if (ans != 1) {
                this.updateStatus("No responce... " + attempts);
                this.delay(300);
            }
            attempts = (byte)(attempts + 1);
        }
        if (ans != 1) {
            this.updateStatus("Could not find valid bootloader");
            this.log.close();
            this.com.stop();
            this.exit();
        }
        int pageIdx = 1;
        attempts = 0;
        x = 0;
        while (x < len && attempts < 5) {
            int frameSize = ((o[x] & 0xFF) << 8 | o[x + 1] & 0xFF) + 2;
            this.log.println("Page: " + pageIdx + ". Size: " + frameSize);
            this.log.flush();
            byte[] pg = new byte[frameSize];
            int i = 0;
            while (i < frameSize) {
                pg[i] = o[x + i];
                ++i;
            }
            this.log.println(this.byteA2hex(pg));
            this.log.flush();
            byte[] comAns = new byte[20];
            while (comAns.length > 0) {
                comAns = this.comRx(50, 20);
                if (comAns.length <= 0) continue;
                this.log.println("Serial trash -> " + this.byteA2hex(comAns));
                this.log.flush();
            }
            this.com.write(pg);
            this.progress = 100.0f * PApplet.parseFloat((int)x) / PApplet.parseFloat((int)len);
            this.updateStatus("Burning page " + pageIdx);
            this.delay(200);
            comAns = this.comRx(2000, 1);
            if (comAns.length > 0) {
                this.log.println("Serial answer -> " + this.byteA2hex(comAns));
                this.log.flush();
                if (comAns[0] != 17) {
                    attempts = (byte)(attempts + 1);
                    String err = "unknown (0x" + this.bin2hex(comAns[0]) + ")";
                    if (comAns[0] == 34) {
                        err = "CRC";
                    }
                    this.updateStatus(String.valueOf(err) + " error for page " + pageIdx + " failed. retry " + attempts);
                    x -= frameSize;
                } else {
                    attempts = 0;
                    ++pageIdx;
                }
            } else {
                this.updateStatus("no answer");
                attempts = (byte)(attempts + 1);
                x -= frameSize;
            }
            this.delay(200);
            this.com.clear();
            x += frameSize;
        }
        if (attempts == 5) {
            this.updateStatus("Error");
        } else {
            this.updateStatus("Done.");
            this.progress = 100.0f;
        }
        this.log.close();
        this.com.stop();
        this.state = (byte)5;
    }

    public void refreshPorts() {
        String[] tmpList = Serial.list();
        String[] exclude = this.loadStrings("exclude-serial.txt");
        if (exclude == null) {
            this.ports = tmpList;
            DM_firmware_loader_v01.println((String)"null");
            return;
        }
        if (tmpList == null) {
            this.ports = null;
            return;
        }
        this.ports = new String[tmpList.length];
        int i = 0;
        int a = 0;
        while (a < tmpList.length) {
            boolean exc = false;
            int b = 0;
            while (b < exclude.length) {
                if (DM_firmware_loader_v01.trim((String)tmpList[a]).equals(DM_firmware_loader_v01.trim((String)exclude[b]))) {
                    exc = true;
                }
                ++b;
            }
            if (!exc) {
                this.ports[i] = tmpList[a];
                ++i;
            }
            ++a;
        }
    }

    public byte[] comRx(int timeout, int expectLen) {
        int begin = this.millis();
        byte[] inBuffer = new byte[expectLen];
        while (this.com.available() < expectLen && begin + timeout > this.millis()) {
        }
        begin = this.com.available();
        if (begin < expectLen) {
            inBuffer = new byte[begin];
        }
        this.com.readBytes(inBuffer);
        return inBuffer;
    }

    public void drawButton(String txt, int x1, int y1, int x2, int y2, int act) {
        if (act < 0 || act > 20) {
            return;
        }
        if (this.mouseX >= x1 && this.mouseX <= x2 && this.mouseY >= y1 && this.mouseY <= y2 && (this.state == 1 || act > 18)) {
            if (this.mousePressed) {
                this.colorPressed();
                if (!this.buttonsPushed[act]) {
                    this.buttonAction(act);
                }
                this.buttonsPushed[act] = true;
            } else {
                this.colorHover();
                this.buttonsPushed[act] = false;
            }
        } else {
            this.colorDefault();
            if (!this.mousePressed) {
                this.buttonsPushed[act] = false;
            }
        }
        this.rect(x1, y1, x2 - x1, y2 - y1);
        this.colorText();
        this.text(txt, x1 + 10, y1 + (y2 - y1) / 2 + 6);
    }

    public void colorPressed() {
        this.stroke(180);
        this.fill(110.0f, 40.0f, 40.0f);
    }

    public void colorText() {
        this.fill(240);
        this.noStroke();
        this.textSize(14.0f);
    }

    public void colorDefault() {
        this.stroke(180);
        this.fill(50.0f, 50.0f, 80.0f);
    }

    public void colorHover() {
        this.stroke(180);
        this.fill(60.0f, 60.0f, 90.0f);
    }

    public byte checkSig(byte[] sig) {
        int i = 0;
        while (i < this.supDevices.length) {
            boolean hit = true;
            int x = 0;
            while (x < this.supDevices[0].length) {
                if (this.supMask[i][x] == 49 && sig[x] != this.supDevices[i][x]) {
                    hit = false;
                }
                x = (byte)(x + 1);
            }
            if (hit) {
                if (this.supReboot[i]) {
                    return 2;
                }
                return 1;
            }
            i = (byte)(i + 1);
        }
        return 0;
    }

    public void updateStatus(String status) {
        this.txtStatus = status;
        if (status == null) {
            status = "Null";
        }
        this.log.println(status);
        this.log.flush();
    }

    public String byteA2hex(byte[] array) {
        String out = "";
        if (array != null) {
            int i = 0;
            while (i < array.length) {
                out = String.valueOf(out) + this.bin2hex(array[i]);
                ++i;
            }
        }
        return out;
    }

    public byte ascii2hex(byte in) {
        if (in >= 48 && in <= 57) {
            return (byte)(in - 48);
        }
        if (in >= 65 && in <= 70) {
            return (byte)(in - 55);
        }
        if (in >= 97 && in <= 102) {
            return (byte)(in - 87);
        }
        return 0;
    }

    public char bin2hex1(byte in) {
        if (in < 10) {
            return (char)(48 + in);
        }
        if (in < 16) {
            return (char)(65 + in - 10);
        }
        return '0';
    }

    public String bin2hex(byte in) {
        char[] ans = new char[]{'0', '0', ' '};
        byte tmp = (byte)((in & 0xF0) / 16);
        ans[0] = this.bin2hex1(tmp);
        tmp = (byte)(in & 0xF);
        ans[1] = this.bin2hex1(tmp);
        String a = new String(ans);
        return a;
    }

    public void settings() {
        this.size(600, 490);
    }

    public static void main(String[] passedArgs) {
        String[] appletArgs = new String[]{"DM_firmware_loader_v01"};
        if (passedArgs != null) {
            PApplet.main((String[])DM_firmware_loader_v01.concat((String[])appletArgs, (String[])passedArgs));
        } else {
            PApplet.main((String[])appletArgs);
        }
    }
}

